<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UnitServiceController;
use App\Http\Controllers\Api\CustomerAuthController;
use App\Http\Controllers\Api\ScanQrAccessController;
use App\Http\Controllers\Api\SupportTicketController;
use App\Http\Controllers\Api\InventoryController;




// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });




Route::prefix('customer')->group(function () {
        Route::post('register', [CustomerAuthController::class, 'register']);
        Route::post('login', [CustomerAuthController::class, 'login'])->name('login');
        Route::post('send-otp', [CustomerAuthController::class, 'sendOtp'])->name('send.otp');
        Route::post('login-with-otp', [CustomerAuthController::class, 'loginWithOtp'])->name('login.otp');

        //Dynamic BookingID encrypted format
        Route::post('/encryptedBKId', [ScanQrAccessController::class, 'encryptedBKId']);

        //RFID scanner functionality
        Route::post('/validate-qr', [ScanQrAccessController::class, 'scanQrAccess']);

        //kiosk Machine Status
        Route::post('/kiosk-scan', [ScanQrAccessController::class, 'checkQrAccessStatus']);

       // Protected routes using the customer guard.
        Route::middleware('auth:customer')->group(function () {
            Route::post('profile', [CustomerAuthController::class, 'profile']);
            Route::post('logout', [CustomerAuthController::class, 'logout']);
            Route::post('refresh', [CustomerAuthController::class, 'refresh']);
            Route::post('bookinghistory', [UnitServiceController::class, 'customerbookinghistory']);
            Route::post('customerbookingdetails', [UnitServiceController::class, 'customerbookingdetailshistory']);
            Route::post('All-Units', [UnitServiceController::class, 'allUnits']);
            Route::post('/Api-get-Unit-services', [UnitServiceController::class, 'getServicesByUnit']);
            Route::post('/Api-initiateBooking', [UnitServiceController::class, 'initiateBooking']);
            Route::post('/Api-SuccessBooking', [UnitServiceController::class, 'paymentSuccessbooking']);
			
			Route::post('get-states', [UnitServiceController::class, 'getStates']);
			Route::post('get-districts', [UnitServiceController::class, 'getDistricts']);
			Route::post('get-units', [UnitServiceController::class, 'getUnits']);
            Route::post('delete_cart', [UnitServiceController::class, 'Payment_fail_delete_cart']);
                Route::post('validate-mem-phone', [UnitServiceController::class, 'validateMemberPhone']);
            Route::post('send-otp-member', [UnitServiceController::class, 'memsendOtp']);
            Route::post('verify-otp-member', [UnitServiceController::class, 'memverifyOtp']);

                  //Inventory
             Route::post('/inv-get-states', [InventoryController::class, 'inv_get_states']);
             Route::post('/inv-states-Wise-District', [InventoryController::class, 'inv_states_wise_district']);
             Route::post('/inv-stores', [InventoryController::class, 'inv_stores']);
             Route::post('/inv-Category', [InventoryController::class, 'Inv_Category']);
            Route::post('/inv-Category-wise-Item', [InventoryController::class, 'inv_Category_wise_Item']);
            Route::post('/inv-item-wise-consumption-qnty', [InventoryController::class, 'getItemMeasurement']);
            Route::post('/inv-entry-store-stock', [InventoryController::class, 'store_stock_entry']);
            Route::post('/inv-Store-stock-View', [InventoryController::class, 'inv_Store_stock_View']);
            Route::post('/inv-Store-To-Unit-Allocate', [InventoryController::class, 'inv_Store_To_Unit_Allocate']);
            Route::post('/inventory/consume', [InventoryController::class, 'consumeInventory']);
            Route::post('/inventory/Unit/Stock', [InventoryController::class, 'getUnitInventoryStocks']);
            Route::post('/inventory/Unit-stock-allotment', [InventoryController::class, 'allotUnitStock']);
            Route::post('/inventory/all-items', [InventoryController::class, 'inv_all_items']);
        });


       
});
