<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Tymon\JWTAuth\Contracts\JWTSubject;

class CustomerModel extends Authenticatable implements JWTSubject
{
    use HasFactory, Notifiable;

    protected $table = 'customers'; // Your custom table name
    public $timestamps = true; // Enable timestamps
    protected $guarded = []; // Allow mass assignment for all attributes

    /**
     * Get the identifier that will be stored in the JWT token.
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return any custom claims to add to the JWT token.
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}
