<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingItemModel extends Model
{
    use HasFactory;
    protected $table = 'booking_item';
    public $timestamps = true;
    protected $guarded = [];

    public function service()
    {
        // 'assign_service_id' is the foreign key in BookingItemModel that refers to the 'id' field in the ServiceModel
        return $this->belongsTo(ServicesModel::class, 'assign_service_id');  // foreign key 'assign_service_id'
    }
}
