<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use App\Models\OrderModel;
use App\Models\BookingItemModel;
use App\Models\DeviceMappingModel;
use Carbon\carbon;


use Illuminate\Http\Request;

class ScanQrAccessController extends Controller
{

    public function scanQrAccess(Request $request)
{
        date_default_timezone_set('Asia/Kolkata');

    $encryptbkId = $request->input('BookingID');
    $deviceId   = $request->input('DeviceID');
    $scanTime   = Carbon::now();

    /* -------------------- BOOKING -------------------- */
    $bkdtl = OrderModel::where('encrypt_BookingID', $encryptbkId)->first();
    if (!$bkdtl) {
        return response()->json([
            'StatusCode' => 400,
            'DeviceID' => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'Record not found.'
        ]);
    }

    /* -------------------- DEVICE -------------------- */
    $deviceMappings = DeviceMappingModel::where('device_id', $deviceId)->get();
    if ($deviceMappings->isEmpty()) {
        return response()->json([
            'StatusCode' => 400,
            'DeviceID' => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'Access Denied'
        ]);
    }

    $unitId = $deviceMappings->first()->unit_id;

    /* -------------------- UNIT + PAYMENT -------------------- */
    $booking = OrderModel::where('booking_id', $bkdtl->booking_id)
        ->where('unit_no', $unitId)
        ->where('Payment_status', 'PAYMENT_SUCCESS')
        ->first();

    if (!$booking) {
        return response()->json([
            'StatusCode' => 400,
            'DeviceID' => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'Access Denied'
        ]);
    }

    /* =========================================================
       MAIN GATE LOGIC (service_id = 0) — EXACT PLACE
       ========================================================= */
    if ($deviceMappings->pluck('service_id')->contains(0)) {

        $createdAt = Carbon::parse($bkdtl->created_at);
        $minutesSinceBooking = $createdAt->diffInMinutes($scanTime);

        if ($minutesSinceBooking <= 60) {
            return response()->json([
                'StatusCode'   => 200,
                'DeviceID'     => $deviceId,
                'SuccesStatus' => "0",
                'ErrorMessage' => 'Access Granted'
            ]);
        }

        return response()->json([
            'StatusCode'   => 403,
            'DeviceID'     => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'QR expired'
        ]);
    }

    /* -------------------- SERVICE MATCH -------------------- */
    $bookingServiceIds = BookingItemModel::where('booking_id', $bkdtl->booking_id)
        ->pluck('assign_service_id')
        ->toArray();

    $deviceServiceIds = $deviceMappings->pluck('service_id')->toArray();

    $matchedServiceIds = array_intersect($bookingServiceIds, $deviceServiceIds);

    if (empty($matchedServiceIds)) {
        return response()->json([
            'StatusCode' => 400,
            'DeviceID' => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'Access Denied'
        ]);
    }

    $serviceId = array_values($matchedServiceIds)[0];

    /* -------------------- QUANTITY CHECK -------------------- */
    $item = BookingItemModel::where('booking_id', $bkdtl->booking_id)
        ->where('assign_service_id', $serviceId)
        ->first();

    if (!$item || $item->used_qnty >= $item->qnty) {
        return response()->json([
            'StatusCode' => 400,
            'DeviceID' => $deviceId,
            'SuccesStatus' => "1",
            'ErrorMessage' => 'Already Used'
        ]);
    }

    $item->increment('used_qnty');

    /* -------------------- SUCCESS -------------------- */
    return response()->json([
        'StatusCode' => 200,
        'DeviceID' => $deviceId,
        'SuccesStatus' => "0",
        'ErrorMessage' => 'Access Granted.'
    ]);
//       date_default_timezone_set('Asia/Kolkata');

//     // return response()->json([
//     //     'StatusCode' => 200,
//     //     'SuccesStatus' => "0",
//     //     'ErrorMessage' => 'Access Granted.'
//     // ]);
//     $encryptbkId = $request->input('BookingID');
//     $deviceId = $request->input('DeviceID');
//     // $scanTime = $request->input('AccessDate');

//      $scanTime = date('Y-m-d H:i:s');




//         try {
//         $scanTime = $scanTime ? Carbon::parse($scanTime) : Carbon::now();
//     } catch (\Exception $e) {
//         $scanTime = Carbon::now();
//     }


//     $bkdtl=OrderModel::where('encrypt_BookingID', $encryptbkId)->first();

// $device = DeviceMappingModel::where('device_id', $deviceId)->get();

// if ($device->isEmpty()) {
//     return response()->json([
//         'StatusCode' => 400,
//         'DeviceID' => $deviceId,
//         'SuccesStatus' => "1",
//         'ErrorMessage' => 'Device not registered.'
//     ]);
// }



    
// if (!$bkdtl) {
//     return response()->json([
//         'StatusCode' => 400,
//         'DeviceID' => $deviceId,
//         'SuccesStatus' => "1",
//         'ErrorMessage' => 'Invalid Booking ID or record not found.'
//     ]);
// }





//    $unitId = $device->first()->unit_id;
//    $serviceId = $device->service_id;



//     $booking = OrderModel::where('booking_id', $bkdtl->booking_id)
//                       ->where('unit_no', $unitId)
//                       ->where('Payment_status', 'PAYMENT_SUCCESS')
//                       ->first();

//     if (!$booking) {
//         return response()->json([
//             'StatusCode' => 400,
//             'DeviceID' => $deviceId,
//             'SuccesStatus' => "1",
//             'ErrorMessage' => 'Invalid booking for this unit.'
//         ]);
//     }


//       if ($serviceId == 0) {

//          $createdAt = Carbon::parse($bkdtl->created_at);
//     $minutesSinceBooking = $createdAt->diffInMinutes($scanTime);
//     $allowedWindowMinutes = 60; // 1 hour

//     if ($minutesSinceBooking <= $allowedWindowMinutes) {
       
//         return response()->json([
//             'StatusCode'   => 200,
//             'DeviceID'     => $deviceId,
//             'SuccesStatus' => "0",
//             'ErrorMessage' => 'Access Granted (Main Gate).',
//             'BookingCreatedAt' => $createdAt->toDateTimeString(),
//             'ScanTime' => $scanTime->toDateTimeString(),
//             'MinutesSinceBooking' => $minutesSinceBooking
//         ]);
//     } else {
    
//         return response()->json([
//             'StatusCode'   => 403,
//             'DeviceID'     => $deviceId,
//             'SuccesStatus' => "1",
//             'ErrorMessage' => 'QR expired — booking created more than 1 hour ago.',
//             'BookingCreatedAt' => $createdAt->toDateTimeString(),
//             'ScanTime' => $scanTime->toDateTimeString(),
//             'MinutesSinceBooking' => $minutesSinceBooking
//         ]);
//     }
//     }



  
//     $item = BookingItemModel::where('booking_id', $bkdtl->booking_id)
//                        ->where('assign_service_id', $serviceId)
//                        ->first();


//     if (!$item) {
//         return response()->json([
//             'StatusCode' => 400,
//             'DeviceID' => $deviceId,
//             'SuccesStatus' => "1",
//             'ErrorMessage' => 'Service not booked for this gate.'
//         ]);
//     }

  
//     if ($item->used_qnty >= $item->qnty) {
//         return response()->json([
//             'StatusCode' => 400,
//             'DeviceID' => $deviceId,
//             'SuccesStatus' => "1",
//             'ErrorMessage' => 'Service usage limit reached.'
//         ]);
//     }

 
//     $item->used_qnty += 1;
//     $item->save();



//     return response()->json([
//         'StatusCode' => 200,
//         'DeviceID' => $deviceId,
//         'SuccesStatus' => "0",
//         'ErrorMessage' => 'Access Granted.'
//     ]);
}

public function encryptedBKId(Request $request)
{

    // return response()->json([
    //     'StatusCode' => 200,
    //     'SuccesStatus' => "0",
    //     'ErrorMessage' => 'Access Granted.'
    // ]);
    $bookingId = $request->input('BookingID');
    $hexString = strtoupper(substr(hash('sha256', $bookingId), 0, 16));
    

    return response()->json([
        'StatusCode' => 200,
        'Encrypted_BookingID' => $hexString,
        'ErrorMessage' => 'SuccessFull'
    ]);
}



// public function checkQrAccessStatus(Request $request)
// {
//     $encryptbkId = $request->input('BookingID');

//     // Step 1: Get booking detail
//     $bkdtl = OrderModel::where('encrypt_BookingID', $encryptbkId)
//                 ->where('Payment_status', 'PAYMENT_SUCCESS')
//                 ->first();

//     if (!$bkdtl) {
//         return response()->json([
//             'StatusCode' => 400,
//             'Status' => 'Invalid',
//             'ErrorMessage' => 'Invalid or unpaid booking ID.'
//         ]);
//     }

//     // Step 2: Get all booked items
//     $items = BookingItemModel::where('booking_id', $bkdtl->booking_id)->get();

//     if ($items->isEmpty()) {
//         return response()->json([
//             'StatusCode' => 400,
//             'Status' => 'Invalid',
//             'ErrorMessage' => 'No service booked under this Booking ID.'
//         ]);
//     }

//     // Step 3: Check if any service is still available
//     $available = $items->contains(function ($item) {
//         return $item->used_qnty < $item->qnty;
//     });

//     return response()->json([
//         'StatusCode' => 200,
//         'Status' => $available ? 'Available' : 'Used',
//         'ErrorMessage' => $available ? 'Some service(s) still available.' : 'All services used.'
//     ]);
// }



public function checkQrAccessStatus(Request $request)
{
    $encryptbkId = $request->input('BookingID');

   
    $bkdtl = OrderModel::where('encrypt_BookingID', $encryptbkId)
                ->where('Payment_status', 'PAYMENT_SUCCESS')
                ->first();

    if (!$bkdtl) {
        return response()->json([
            'StatusCode' => 400,
            'Status' => 'Invalid',
            'ErrorMessage' => 'Invalid or unpaid booking ID.'
        ]);
    }

  
    $items = BookingItemModel::where('booking_id', $bkdtl->booking_id)->get();

    if ($items->isEmpty()) {
        return response()->json([
            'StatusCode' => 400,
            'Status' => 'Invalid',
            'ErrorMessage' => 'No service booked under this Booking ID.'
        ]);
    }


    $availableItem = $items->first(function ($item) {
        return $item->used_qnty < $item->qnty;
    });

    if (!$availableItem) {
        return response()->json([
            'StatusCode' => 400,
            'Status' => 'Used',
            'ErrorMessage' => 'All services fully used.'
        ]);
    }


    $availableItem->used_qnty += 1;
    $availableItem->save();

    return response()->json([
        'StatusCode' => 200,
        'Status' => 'Available',
        'ErrorMessage' => 'Access Granted. Service usage updated successfully.'
    ]);


}




    
}
