<?php

//live

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Models\AssignInventoryStockModel;
use App\Models\AddInventoryStockModel;
use App\Models\InventoryItemModel;
use App\Models\InventoryAllotmentModel;
use Illuminate\Support\Facades\DB;
use App\Models\InventoryCategoryModel;
use App\Models\StoreRoomModel;
use App\Models\InventoryConsumptionModel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Crypt;
use App\Models\DistrictServiceModel;
use App\Models\StateAdminModel;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
class InventoryController extends Controller
{
   public function inv_get_states(): JsonResponse
    {

        try {
            $states = StateAdminModel::select('id', 'state_name')->get();

            return response()->json([
                'status' => 'success',
                'message' => 'States retrieved successfully',
                'data' => $states
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage()
            ], 500);
        }
    }
       public function inv_states_wise_district(Request $request): JsonResponse
    {
$request->validate([
        'state' => 'required|string'
    ]);

    try {
        $districts = DistrictServiceModel::where('state_id', $request->state)
            ->select('id as district_id', 'district_name') // <-- Add dist id & name
            ->orderBy('id', 'ASC')
            ->get();

        return response()->json([
            'status' => 'success',
            'message' => 'Districts retrieved successfully',
            'data' => $districts
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }
    }

           public function inv_stores(Request $request): JsonResponse
    {
$request->validate([
        'state' => 'required|string',
        'district' => 'required|string',
      
    ]);

    try {
        $allstores = StoreRoomModel::where('state_id', $request->state)->where('district_id', $request->district)
            ->select('id as storeid', 'storeroom_name') // <-- Add dist id & name
            ->orderBy('id', 'ASC')
            ->get();
              if ($allstores->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'No store found for the selected state and district',
            'data' => []
        ]);
    }

        return response()->json([
            'status' => 'success',
            'message' => 'Store retrieved successfully',
            'data' => $allstores
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }
    }

              public function Inv_Category(Request $request): JsonResponse
    {


    try {
        $inv_categories=InventoryCategoryModel::select('id as categoryID', 'invcatgeoryname')->get();
     
              if ($inv_categories->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'No Category found',
            'data' => []
        ]);
    }

        return response()->json([
            'status' => 'success',
            'message' => 'Category retrieved successfully',
            'data' => $inv_categories
        ]);
        
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }
    }

    public function inv_Category_wise_Item(request $request){
        $request->validate([
        'category_id' => 'required|string',
      
    ]);
           $items = InventoryItemModel::where('category_inv', $request->category_id)
              ->select('id','item_name') 
              ->get();

                        if ($items->isEmpty()) {
        return response()->json([
            'status' => 'error',
            'message' => 'No Item found',
            'data' => []
        ]);
    }

                    return response()->json([
            'status' => 'success',
            'message' => 'Item retrieved successfully',
            'data' => $items
        ]);


    }


    public function getItemMeasurement(Request $request)
{
    $item = InventoryItemModel::with('measurement')->find($request->itemid);

    if ($item && $item->measurement) {
        return response()->json([
            'status' => true,
            'unit_id' => $item->measurement_unit_id,
            'unit_name' => $item->measurement->measurement_unit,
            'sub_unit_qnty' => $item->sub_unit_qnty
        ]);
    }

    return response()->json(['status' => false]);
}

public function store_stock_entry(Request $request)
{
    try {

        date_default_timezone_set('Asia/Kolkata');

        // ✅ VALIDATION
        $request->validate([
            'unit_state'   => 'required|integer',
            'unit_dist'    => 'required|integer',
            'str_room_id'  => 'required|integer',
            'categeoryval' => 'required|integer',
            'item_id'      => 'required|integer|exists:inventory_items,id',

            // qty fields optional (unit ke hisab se)
            'liter_qty'         => 'nullable|numeric|min:0',
            'packet_qty'        => 'nullable|numeric|min:0',
            'piece_qty'         => 'nullable|numeric|min:0',
            'piece_qty_direct' => 'nullable|numeric|min:0',
            'pair_qty'          => 'nullable|numeric|min:0',
            'kg_qty'            => 'nullable|numeric|min:0',
        ]);

        // ✅ ITEM FETCH
        $item = InventoryItemModel::find($request->item_id);

        if (!$item) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Item not found'
            ], 404);
        }

        $finalQty = 0;

        // ✅ YOUR EXACT MEASUREMENT LOGIC (UNCHANGED)
        if ($item->measurement_unit_id == 1) {
            // Liter item
            $finalQty = $request->liter_qty ?? 0;
        }
        elseif ($item->measurement_unit_id == 2) {
            // Packet item
            $packets = $request->packet_qty ?? 0;
            $pieces  = $request->piece_qty ?? 0;
            $finalQty = ($packets * $pieces);
        }
        elseif ($item->measurement_unit_id == 3) {
            // Piece item
            $finalQty = $request->piece_qty ?? 0;
        }
        elseif ($item->measurement_unit_id == 6) {
            // Pair item
            $finalQty = $request->pair_qty ?? 0;
        }
        elseif ($item->measurement_unit_id == 7) {
            // KG item
            $finalQty = $request->kg_qty ?? 0;
        }

        // ✅ FINAL QTY VALIDATION
        if ($finalQty <= 0) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Invalid quantity. Quantity must be greater than 0.'
            ], 422);
        }

        //    return response()->json([
        //         'status'  => 'success',
        //         'uit_qnty' => $item->measurement_unit_id,
        //         'Final Qnty'    => $finalQty,
        //     ], 201);

        // ✅ CHECK EXISTING STOCK
        $existingStock = AddInventoryStockModel::where('state_id', $request->unit_state)
            ->where('district_id', $request->unit_dist)
            ->where('restroom_id', $request->str_room_id)
            ->where('item_id', $request->item_id)
            ->first();

            //      return response()->json([
            //     'status'  => 'success',
            //     'uit_qnty' => $item->measurement_unit_id,
            //     'Final Qnty'    => $finalQty,
            //     'existingStock'    => $existingStock->qty,
            //      'final_qnty'    => $existingStock->qty += $finalQty,
            // ], 200);

        // ✅ UPDATE STOCK
        if ($existingStock) {

            $existingStock->qty += $finalQty;

             $existingStock->packet_qty = $request->packet_qty ?? 0;
    $existingStock->piece_qty  = $request->piece_qty ?? 0;
    $existingStock->liter_qty  = $request->liter_qty ?? 0;
            $existingStock->save();

            return response()->json([
                'status'  => 'success',
                'message' => 'Stock updated successfully',
                'data'    => $existingStock
            ], 200);

        } 
        // ✅ INSERT NEW STOCK
        else {

            $storeInventoryStock = AddInventoryStockModel::create([
                'state_id'        => $request->unit_state,
                'district_id'     => $request->unit_dist,
                'restroom_id'     => $request->str_room_id,
                'categoryID'      => $request->categeoryval,
                'item_id'         => $request->item_id,
                'measurement_id' => $item->measurement_unit_id,
                'qty'             => $finalQty,

                // reference values
                'packet_qty' => $request->packet_qty ?? 0,
                'piece_qty'  => $request->piece_qty ?? 0,
                'liter_qty'  => $request->liter_qty ?? 0,
            ]);

            return response()->json([
                'status'  => 'success',
                'message' => 'Stock added successfully',
                'data'    => $storeInventoryStock
            ], 201);
        }

    }
    // ✅ VALIDATION ERROR
    catch (\Illuminate\Validation\ValidationException $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Validation failed',
            'errors'  => $e->errors()
        ], 422);

    }
    // ✅ GENERAL ERROR
    catch (\Exception $e) {

        return response()->json([
            'status'  => 'error',
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}



public function inv_Store_stock_View(Request $request)
{
    date_default_timezone_set('Asia/Kolkata');

    try {

     
        $query = AddInventoryStockModel::join(
                    'inventory_items',
                    'inventory_items.id',
                    '=',
                    'storeroom_inventory_stock.item_id'
                )
                ->join(
                    'inventory_category',
                    'inventory_category.id',
                    '=',
                    'storeroom_inventory_stock.categoryID'
                )
                ->join(
                    'store_room',
                    'store_room.id',
                    '=',
                    'storeroom_inventory_stock.restroom_id'
                )
                ->select(
                    'storeroom_inventory_stock.*',
                    'inventory_items.item_name',
                    'inventory_items.low_qnty',
                    'inventory_items.measurement_unit_id',
                    'inventory_category.invcatgeoryname',
                    'store_room.storeroom_name'
                );


        if (!empty($request->item_id)) {
            $query->where('storeroom_inventory_stock.item_id', $request->item_id);
        }

        if (!empty($request->store_id)) {
            $query->where('storeroom_inventory_stock.restroom_id', $request->store_id);
        }

        if (!empty($request->category_id)) {
            $query->where('storeroom_inventory_stock.categoryID', $request->category_id);
        }

        if (!empty($request->state_id)) {
            $query->where('storeroom_inventory_stock.state_id', $request->state_id);
        }

        if (!empty($request->district_id)) {
            $query->where('storeroom_inventory_stock.district_id', $request->district_id);
        }

  
        $allInvStock = $query->orderBy('storeroom_inventory_stock.id', 'DESC')->get();

        $allInvStock->transform(function ($stock) {

            switch ($stock->measurement_unit_id) {
                case 1:  $stock->display_unit = 'ml'; break;
                case 2:  $stock->display_unit = 'pcs'; break;
                case 3:  $stock->display_unit = 'pcs'; break;
                case 6:  $stock->display_unit = 'Pair'; break;
                case 7:  $stock->display_unit = 'gram'; break;
                default: $stock->display_unit = ''; break;
            }

    
            $stock->is_low_stock = ($stock->qty <= $stock->low_qnty);


            $stock->stock_color = $stock->is_low_stock ? 'red' : 'black';

            return $stock;
        });

        return response()->json([
            'status'  => true,
            'message' => 'Store room inventory stock fetched successfully',
            'data'    => $allInvStock
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            'status'  => false,
            'message' => 'Something went wrong',
            'error'   => $e->getMessage()
        ], 500);
    }
}

// public function inv_Store_stock_View(Request $request){
//  date_default_timezone_set('Asia/Kolkata');
//      try {
//         $allInvStock = AddInventoryStockModel::join(
//                 'inventory_items',
//                 'inventory_items.id',
//                 '=',
//                 'storeroom_inventory_stock.item_id'
//             )
//             ->join(
//                 'inventory_category',
//                 'inventory_category.id',
//                 '=',
//                 'storeroom_inventory_stock.categoryID'
//             )
//             ->join(
//                 'store_room',
//                 'store_room.id',
//                 '=',
//                 'storeroom_inventory_stock.restroom_id'
//             )
//             ->select(
//                 'storeroom_inventory_stock.*',
//                 'inventory_items.item_name',
//                 'inventory_items.low_qnty',
//                 'inventory_items.measurement_unit_id',
//                 'inventory_category.invcatgeoryname',
//                 'store_room.storeroom_name'
//             )
//             ->get();

//         // ✅ SHIFT UI LOGIC INTO CONTROLLER
//         $allInvStock->transform(function ($stock) {

//             // ✅ Unit Name Logic
//             if ($stock->measurement_unit_id == 1) {
//                 $stock->display_unit = 'ml';
//             } elseif ($stock->measurement_unit_id == 2) {
//                 $stock->display_unit = 'pcs';
//             } elseif ($stock->measurement_unit_id == 3) {
//                 $stock->display_unit = 'pcs';
//             } elseif ($stock->measurement_unit_id == 6) {
//                 $stock->display_unit = 'Pair';
//             } elseif ($stock->measurement_unit_id == 7) {
//                 $stock->display_unit = 'gram';
//             } else {
//                 $stock->display_unit = '';
//             }

//             // ✅ Low Stock Check
//             $stock->is_low_stock = ($stock->qty <= $stock->low_qnty);

//             // ✅ Optional Color Flag
//             $stock->stock_color = $stock->is_low_stock ? 'red' : 'black';

//             return $stock;
//         });

//         return response()->json([
//             'status'  => true,
//             'message' => 'Inventory stock fetched successfully',
//             'data'    => $allInvStock
//         ], 200);

//     } catch (\Exception $e) {
//         return response()->json([
//             'status'  => false,
//             'message' => 'Something went wrong',
//             'error'   => $e->getMessage()
//         ], 500);
//     }


// }


public function inv_Store_To_Unit_Allocate(Request $request){
 date_default_timezone_set(timezoneId: 'Asia/Kolkata');
    try {

        // ✅ VALIDATION
        // $request->validate([
        //     'storeroom_id'         => 'required|integer',
        //     'item_id'              => 'required|integer',
        //     'unit_id'              => 'required|integer',
        //     'state_id'             => 'required|integer',
        //     'district_id'          => 'required|integer',
        //     'allotment_qty'        => 'required|numeric|min:0.01',
        //     'measurement_unit_id'  => 'required|integer',
        //     'categoryID'           => 'required|integer',
        // ]);

        // ✅ FIND STOCK
        $stock = AddInventoryStockModel::where('restroom_id', $request->source_id)
            ->where('item_id', $request->item_id)
            ->first();

            //     return response()->json([
            //     'status' => false,
            //     'message' => $stock
            // ], 404);

        if (!$stock) {
            return response()->json([
                'status' => false,
                'message' => 'No stock found for this storeroom and item.'
            ], 404);
        }

        // ✅ FINAL QTY (No conversion needed as per your logic)
        $finalQty = $request->allotment_qty;

        // ✅ CHECK AVAILABLE STOCK
        if ($stock->qty < $finalQty) {
            return response()->json([
                'status' => false,
                'message' => 'Not enough quantity available.',
                'available_qty' => $stock->qty
            ], 422);
        }

        // ✅ CHECK EXISTING ALLOTMENT
        $existingAllotment = AssignInventoryStockModel::where('destination_id', $request->destination_id)
            ->where('item_id', $request->item_id)
            ->first();

        if ($existingAllotment) {
            // ✅ UPDATE QTY
            $existingAllotment->allotment_qty += $finalQty;
            $existingAllotment->save();
        } else {
            // ✅ CREATE NEW ALLOTMENT
            AssignInventoryStockModel::create([
                'state_id'         => $request->state_id,
                'district_id'      => $request->district_id,
                'source_id'        => $request->source_id,
                'item_id'          => $request->item_id,
                'destination_id'  => $request->destination_id,
                'allotment_qty'   => $finalQty,
                'categoryID'      => $request->categoryID,
                'measurement_id' => $request->measurement_unit_id,
                'source_type'      => 'storeroom',
                'destination_type' => 'unit',
            ]);
        }

        // ✅ DEDUCT FROM STORE STOCK
        $stock->qty -= $finalQty;
        $stock->save();

        // ✅ INSERT INTO ALLOTMENT LOG
        InventoryAllotmentModel::create([
            'source_type'        => 'storeroom',
            'source_id'          => $request->source_id,
            'destination_type'  => 'unit',
            'destination_id'    => $request->destination_id,
            'item_id'           => $request->item_id,
            'measurement_id'    => $request->measurement_unit_id,
            'final_qty'         => $finalQty,
            'date_of_allotment' => now(),
            'user_type' => "Website",
            'created_by'        => auth()->id() ?? 0,
            'stateID'           => $request->state_id,
            'destrictID'        => $request->district_id,
              'categoryID'        => $request->categoryID,
            'remarks'           => 'Allotment from Storeroom to Unit (API)',
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Inventory allocated successfully.'
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            'status' => false,
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }

}


public function consumeInventory(Request $request)
{
     date_default_timezone_set('Asia/Kolkata');
    $request->validate([
        'source_id'           => 'required|integer',
        'source_type'         => 'required|string|in:store,unit',
        'item_id'             => 'required|integer',
        'consumption_qty'     => 'required|numeric|min:0.01',
        'state_id'            => 'required|integer',
        'district_id'         => 'required|integer',
        'measurement_unit_id' => 'required|integer',
        'category_id'         => 'required|integer',
    ]);

    $sourceId      = $request->source_id;
    $sourceType    = $request->source_type;
    $itemId        = $request->item_id;
    $consumeQty    = $request->consumption_qty;
    $stateId       = $request->state_id;
    $districtId    = $request->district_id;
    $measurementId = $request->measurement_unit_id;
    $categoryID    = $request->category_id;

    // 🔹 1. Fetch Stock
    if ($sourceType === 'unit') {

        $stock = AssignInventoryStockModel::where('state_id', $stateId)
            ->where('district_id', $districtId)
            ->where('destination_id', $sourceId)
            ->where('item_id', $itemId)
            ->first();

        if (!$stock) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Stock not found for this unit.',
            ], 404);
        }

        if ($stock->allotment_qty < $consumeQty) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Not enough stock available.',
            ], 400);
        }

    } else { // source_type == store

        $stock = AddInventoryStockModel::where('state_id', $stateId)
            ->where('district_id', $districtId)
            ->where('restroom_id', $sourceId)
            ->where('item_id', $itemId)
            ->first();

        if (!$stock) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Stock not found for this storeroom.',
            ], 404);
        }

        if ($stock->qty < $consumeQty) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Not enough stock available.',
            ], 400);
        }
    }

    // 🔹 2. Deduct Stock
    if ($sourceType === 'unit') {
        $stock->allotment_qty -= $consumeQty;
    } else {
        $stock->qty -= $consumeQty;
    }
    $stock->save();

    // 🔹 3. Log Consumption
    $log = InventoryConsumptionModel::create([
        'state_id'            => $stateId,
        'district_id'         => $districtId,
        'source_type'         => $sourceType,
        'source_id'           => $sourceId,
        'item_id'             => $itemId,
        'consumed_qty'        => $consumeQty,
        'measurement_id'      => $measurementId,
        'categoryID'          => $categoryID,
        'date_of_consumption' => now(),
          'user_type' => "Website",
        'created_by'          => auth()->id() ?? 0,
        'remarks'             => "Consumed from {$sourceType}"
    ]);

    return response()->json([
        'status'  => 'success',
        'message' => 'Consumption recorded successfully.',
        'data'    => [
            'remaining_stock' => $sourceType === 'unit' 
                ? $stock->allotment_qty 
                : $stock->qty,
            'log'             => $log
        ]
    ], 200);
}


public function getUnitInventoryStocks(Request $request)
{
    try {

        $query = AssignInventoryStockModel::join(
                    'inventory_items', 'inventory_items.id', '=', 'inventory_allotment.item_id'
                )
                ->join('inventory_category', 'inventory_category.id', '=', 'inventory_allotment.categoryID')
                ->join('servisesqr', 'servisesqr.id', '=', 'inventory_allotment.destination_id')
                ->select(
                    'inventory_allotment.*',
                    'inventory_items.item_name',
                    'inventory_items.measurement_unit_id',
                    'inventory_items.low_qnty_unit',
                    'inventory_category.invcatgeoryname',
                    'servisesqr.qrcodeId as unit_name'
                );

        // ----------------------------
        // 🔥 Flexible Filter Conditions
        // ----------------------------

        if (!empty($request->item_id)) {
            $query->where('inventory_allotment.item_id', $request->item_id);
        }

        if (!empty($request->unit_id)) {
            $query->where('inventory_allotment.destination_id', $request->unit_id);
        }

        if (!empty($request->category_id)) {
            $query->where('inventory_allotment.categoryID', $request->category_id);
        }

        if (!empty($request->state_id)) {
            $query->where('inventory_allotment.state_id', $request->state_id);
        }

        if (!empty($request->district_id)) {
            $query->where('inventory_allotment.district_id', $request->district_id);
        }

        $stocks = $query->orderBy('inventory_allotment.id', 'DESC')->get();

        return response()->json([
            "status"   => true,
            "message"  => "Unit stock fetched successfully",
            "data"     => $stocks
        ], 200);

    } catch (\Exception $e) {

        return response()->json([
            "status"   => false,
            "message"  => $e->getMessage()
        ], 500);
    }
}



// public function getUnitInventoryStocks()
// {
//     try {
//         $stocks = AssignInventoryStockModel::join(
//                 'inventory_items', 'inventory_items.id', '=', 'inventory_allotment.item_id'
//             )
//             ->join('inventory_category', 'inventory_category.id', '=', 'inventory_allotment.categoryID')
//             ->join('servisesqr', 'servisesqr.id', '=', 'inventory_allotment.destination_id')
//             ->select(
//                 'inventory_allotment.*',
//                 'inventory_items.item_name',
//                 'inventory_items.measurement_unit_id',
//                 'inventory_items.low_qnty_unit',
//                 'inventory_category.invcatgeoryname',
//                 'servisesqr.qrcodeId as unit_name'
//             )
//             ->orderBy('inventory_allotment.id', 'DESC')
//             ->get();

//         return response()->json([
//             "status" => true,
//             "message" => "Unit stock fetched successfully",
//             "data" => $stocks
//         ], 200);

//     } catch (\Exception $e) {
//         return response()->json([
//             "status" => false,
//             "message" => $e->getMessage()
//         ], 500);
//     }
// }

public function allotUnitStock(Request $request)
{
   

    try {
        $sourceStock = AssignInventoryStockModel::where([
            'state_id'      => $request->state_id,
            'district_id'   => $request->district_id,
            'destination_id'=> $request->source_id,
            'item_id'       => $request->item_id
        ])->first();

        if (!$sourceStock) {
            return response()->json([
                "status"  => false,
                "message" => "Source stock not found"
            ], 404);
        }

        if ($sourceStock->allotment_qty < $request->allot_qty) {
            return response()->json([
                "status"  => false,
                "message" => "Not enough stock in source unit"
            ], 400);
        }

        // Deduct from Source
        $sourceStock->allotment_qty -= $request->allot_qty;
        $sourceStock->save();

        // Add to Destination
        if ($request->destination_type == "unit") {

            $dest = AssignInventoryStockModel::firstOrNew([
                'state_id'      => $request->state_id,
                'district_id'   => $request->district_id,
                'destination_id'=> $request->destination_id,
                'item_id'       => $request->item_id
            ]);

            $dest->allotment_qty = ($dest->allotment_qty ?? 0) + $request->allot_qty;
            $dest->categoryID     = $request->category_id;
            $dest->measurement_id = $request->measurement_id;
            $dest->save();
        } 
        else { // STORE ROOM ALLOTMENT

            $dest = AddInventoryStockModel::firstOrNew([
                'state_id'    => $request->state_id,
                'district_id' => $request->district_id,
                'restroom_id' => $request->destination_id,
                'item_id'     => $request->item_id
            ]);

            $dest->qty            = ($dest->qty ?? 0) + $request->allot_qty;
            $dest->categoryID     = $request->category_id;
            $dest->measurement_id = $request->measurement_id;
            $dest->save();
        }

        // Save in History
        InventoryAllotmentModel::create([
            'stateID'          => $request->state_id,
            'destrictID'       => $request->district_id,
            'source_type'      => 'unit',
            'source_id'        => $request->source_id,
            'destination_type' => $request->destination_type,
            'destination_id'   => $request->destination_id,
            'item_id'          => $request->item_id,
            'final_qty'        => $request->allot_qty,
            'measurement_id'   => $request->measurement_id,
            'date_of_allotment'=> now(),
              'user_type'=> "Website",
            'created_by'       => auth()->id() ?? 0,
            'categoryID'       => $request->category_id,
            'remarks'          => 'Allotment from unit'
        ]);

        return response()->json([
            "status"  => true,
            "message" => "Allotment successful",
        ], 200);

    } catch (\Exception $e) {
        return response()->json([
            "status" => false,
            "message" => $e->getMessage()
        ], 500);
    }
}


public function inv_all_items(){
    $all_inv_items=InventoryItemModel::all();

    
        if (!$all_inv_items) {
            return response()->json([
                'status' => false,
                'message' => 'No stItems in the record.'
            ], 404);
        }

            return response()->json([
            "status"  => true,
            "message" => "Item fetched successfully",
           "data"     => $all_inv_items
        ], 200);



}








    

}
